```toml
[advisory]
id = "RUSTSEC-2021-0051"
package = "outer_cgi"
aliases = ["CVE-2021-30454", "GHSA-6vmq-jh76-hq43"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-31"
url = "https://github.com/SolraBizna/outer_cgi/issues/1"
categories = ["memory-exposure"]

[versions]
patched = [">= 0.2.1"]
```

# KeyValueReader passes uninitialized memory to Read instance

The `KeyValueReader` type in affected versions of this crate set up an
uninitialized memory buffer and passed them to be read in to a user-provided
`Read` instance.

The `Read` instance could read uninitialized memory and cause undefined
behavior and miscompilations.

This issue was fixed in commit [dd59b30](https://github.com/SolraBizna/outer_cgi/commit/dd59b3066e616a08e756f72de8dc3ab11b7036c4)
by zero-initializing the buffers before passing them.
