```toml
[advisory]
id = "RUSTSEC-2020-0012"
package = "os_str_bytes"
aliases = ["CVE-2020-35865", "GHSA-q948-x8rf-888m"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-04-24"
url = "https://github.com/dylni/os_str_bytes/pull/1"

[affected]
os = ["windows"]

[versions]
patched = [">= 2.0.0"]
```

# Relies on undefined behavior of `char::from_u32_unchecked`

The Windows implementation of this crate relied on the behavior of
`std::char::from_u32_unchecked` when its safety clause is violated.
Even though this worked with Rust versions up to 1.42 (at least),
that behavior could change with any new Rust version, possibly leading
a security issue.

The flaw was corrected in version 2.0.0.
