```toml
[advisory]
id = "RUSTSEC-2023-0072"
package = "openssl"
date = "2023-11-23"
url = "https://github.com/sfackler/rust-openssl/issues/2096"
informational = "unsound"
categories = ["memory-corruption"]
aliases = ["GHSA-xphf-cx8h-7q9g"]

[affected]
functions = { "openssl::x509::store::X509StoreRef::objects" = ["< 0.10.60, >=0.10.29"] }

[versions]
patched = [">= 0.10.60"]
```

# `openssl` `X509StoreRef::objects` is unsound

This function returned a shared reference into an OpenSSL datastructure but did not account for interior mutability. OpenSSL may modify the data behind this reference, meaning accesses can race and the reference is unsound.

Use of this function should be replaced with `X509StoreRef::all_certificates`.
