```toml
[advisory]
id = "RUSTSEC-2022-0032"
package = "openssl-src"
aliases = ["CVE-2022-2097", "GHSA-3wx7-46ch-7rq2"]
categories = ["crypto-failure"]
date = "2022-07-05"
url = "https://www.openssl.org/news/secadv/20220705.txt"

[versions]
patched = [">= 111.22, < 300.0", ">= 300.0.9"]
```

# AES OCB fails to encrypt some bytes

AES OCB mode for 32-bit x86 platforms using the AES-NI assembly optimised
implementation will not encrypt the entirety of the data under some
circumstances.  This could reveal sixteen bytes of data that was
preexisting in the memory that wasn't written.  In the special case of
"in place" encryption, sixteen bytes of the plaintext would be revealed.

Since OpenSSL does not support OCB based cipher suites for TLS and DTLS,
they are both unaffected.
