```toml
[advisory]
id = "RUSTSEC-2022-0027"
package = "openssl-src"
aliases = ["CVE-2022-1343", "GHSA-mfm6-r9g2-q4r7"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:L/A:N"
categories = ["crypto-failure"]
date = "2022-05-03"
url = "https://www.openssl.org/news/secadv/20220503.txt"

[versions]
patched = [">= 300.0.6"]
unaffected = ["< 300.0"]
```

# `OCSP_basic_verify` may incorrectly verify the response signing certificate

The function `OCSP_basic_verify` verifies the signer certificate on an OCSP
response. In the case where the (non-default) flag OCSP_NOCHECKS is used then
the response will be positive (meaning a successful verification) even in the
case where the response signing certificate fails to verify.

It is anticipated that most users of `OCSP_basic_verify` will not use the
OCSP_NOCHECKS flag. In this case the `OCSP_basic_verify` function will return
a negative value (indicating a fatal error) in the case of a certificate
verification failure. The normal expected return value in this case would be 0.
