```toml
[advisory]
id = "RUSTSEC-2021-0058"
package = "openssl-src"
aliases = ["CVE-2021-23841", "GHSA-84rm-qf37-fgc2"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2021-05-01"
url = "https://www.openssl.org/news/secadv/20210216.txt"

[versions]
patched = [">= 111.14"]
```

# Null pointer deref in `X509_issuer_and_serial_hash()`

The OpenSSL public API function `X509_issuer_and_serial_hash()` attempts to
create a unique hash value based on the issuer and serial number data contained
within an X509 certificate. However it fails to correctly handle any errors
that may occur while parsing the issuer field (which might occur if the issuer
field is maliciously constructed). This may subsequently result in a NULL
pointer deref and a crash leading to a potential denial of service attack.

The function `X509_issuer_and_serial_hash()` is never directly called by OpenSSL
itself so applications are only vulnerable if they use this function directly
and they use it on certificates that may have been obtained from untrusted
sources.

