```toml
[advisory]
id = "RUSTSEC-2021-0057"
package = "openssl-src"
aliases = ["CVE-2021-23840", "GHSA-qgm6-9472-pwq7"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
categories = ["denial-of-service"]
date = "2021-05-01"
url = "https://www.openssl.org/news/secadv/20210216.txt"

[versions]
patched = [">= 111.14"]
```

# Integer overflow in CipherUpdate

Calls to `EVP_CipherUpdate`, `EVP_EncryptUpdate` and `EVP_DecryptUpdate` may overflow
the output length argument in some cases where the input length is close to the
maximum permissable length for an integer on the platform. In such cases the
return value from the function call will be 1 (indicating success), but the
output length value will be negative. This could cause applications to behave
incorrectly or crash.

