```toml
[advisory]
id = "RUSTSEC-2019-0017"
package = "once_cell"
aliases = ["CVE-2019-16141", "GHSA-7j44-fv4x-79g9"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2019-09-01"
keywords = ["undefined_behavior"]
url = "https://github.com/matklad/once_cell/issues/46"

[affected.functions]
"once_cell::sync::Lazy::deref" = ["< 1.0.1, >= 0.2.5"]
"once_cell::sync::Lazy::force" = ["< 1.0.1, >= 0.2.5"]
"once_cell::unsync::Lazy::deref" = ["< 1.0.1, >= 0.2.5"]
"once_cell::unsync::Lazy::force" = ["< 1.0.1, >= 0.2.5"]

[versions]
patched = [">= 1.0.1"]
unaffected = ["< 0.2.5"]
```

# Panic during initialization of Lazy<T> might trigger undefined behavior

If during the first dereference of Lazy<T> the initialization function panics,
subsequent dereferences will execute `std::hints::unreachable_unchecked`.

Applications with `panic = "abort"` are not affected, as there will be no
subsequent dereferences.
