```toml
[advisory]
id = "RUSTSEC-2024-0358"
package = "object_store"
date = "2024-07-23"
url = "https://github.com/apache/arrow-rs/pull/6074"
references = ["https://www.openwall.com/lists/oss-security/2024/07/23/3"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:C/C:L/I:N/A:N"

keywords = ["information", "leak", "aws", "oidc", "logs"]
aliases = ["CVE-2024-41178"]

[versions]
patched = [">= 0.10.2"]

unaffected = ["< 0.5.0"]
```

# Apache Arrow Rust Object Store: AWS WebIdentityToken exposure in log files

Exposure of temporary credentials in logs in Apache Arrow Rust Object Store,
version 0.10.1 and earlier on all platforms using AWS WebIdentityTokens.

On certain error conditions, the logs may contain the OIDC token passed to
[AssumeRoleWithWebIdentity](https://docs.aws.amazon.com/STS/latest/APIReference/API_AssumeRoleWithWebIdentity.html).
This allows someone with access to the logs to impersonate that identity,
including performing their own calls to AssumeRoleWithWebIdentity, until the
OIDC token expires. Typically OIDC tokens are valid for up to an hour, although
this will vary depending on the issuer.

Users are recommended to use a different AWS authentication mechanism, disable
logging or upgrade to version 0.10.2, which fixes this issue.

## Details

When using AWS WebIdentityTokens with the `object_store` crate, in the event of
a failure and automatic retry, the underlying `reqwest` error, including the
full URL with the credentials, potentially in the parameters, is written to the
logs.

Thanks to Paul Hatcherian for reporting this vulnerability
