```toml
[advisory]
id = "RUSTSEC-2020-0078"
package = "net2"
date = "2020-11-07"
url = "https://github.com/deprecrated/net2-rs/issues/105"
keywords = ["memory", "layout", "cast"]
informational = "unsound"
aliases = ["CVE-2020-35919", "CVE-2020-35920", "GHSA-458v-4hrf-g3m4", "GHSA-c79c-gwph-gqfm"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.2.36"]
```

# `net2` invalidly assumes the memory layout of std::net::SocketAddr

The [`net2`](https://crates.io/crates/net2) crate has assumed `std::net::SocketAddrV4`
and `std::net::SocketAddrV6` have the same memory layout as the system C representation
`sockaddr`. It has simply casted the pointers to convert the socket addresses to the
system representation. The standard library does not say anything about the memory
layout, and this will cause invalid memory access if the standard library
changes the implementation. No warnings or errors will be emitted once the
change happens.
