```toml
[advisory]
id = "RUSTSEC-2019-0006"
package = "ncurses"
aliases = ["CVE-2019-15547", "CVE-2019-15548", "GHSA-32v7-ghpr-c8hg", "GHSA-g7r5-x7cr-vm3v"]
date = "2019-06-15"
url = "https://github.com/RustSec/advisory-db/issues/106"

[affected.functions]
"ncurses::instr" = [">= 0"]
"ncurses::mvprintw" = [">= 0"]
"ncurses::mvwinstr" = [">= 0"]
"ncurses::mvwprintw" = [">= 0"]
"ncurses::printw" = [">= 0"]

[versions]
patched = []
```

# Buffer overflow and format vulnerabilities in functions exposed without unsafe

`ncurses` exposes functions from the ncurses library which:

- Pass buffers without length to C functions that may write an arbitrary amount of
  data, leading to a buffer overflow. (`instr`, `mvwinstr`, etc)
- Passes rust &str to strings expecting C format arguments, allowing hostile
  input to execute a format string attack, which trivially allows writing
  arbitrary data to stack memory (functions in the `printw` family).
