```toml
[advisory]
id = "RUSTSEC-2023-0029"
package = "nats"
date = "2023-03-24"
categories = ["crypto-failure"]
keywords = ["tls", "mitm"]
aliases = ["GHSA-wvc4-j7g5-4f79"]

[versions]
patched = [">=0.24.1"]
unaffected = ["< 0.9.0"]
```

# TLS certificate common name validation bypass

The NATS official Rust clients are vulnerable to MitM when using TLS.

The common name of the server's TLS certificate is validated against
the `host`name provided by the server's plaintext `INFO` message
during the initial connection setup phase. A MitM proxy can tamper with
the `host` field's value by substituting it with the common name of a
valid certificate it controls, fooling the client into accepting it.

## Reproduction steps

1. The NATS Rust client tries to establish a new connection
2. The connection is intercepted by a MitM proxy
3. The proxy makes a separate connection to the NATS server
4. The NATS server replies with an `INFO` message
5. The proxy reads the `INFO`, alters the `host` JSON field and passes
   the tampered `INFO` back to the client
6. The proxy upgrades the client connection to TLS, presenting a certificate issued
   by a certificate authority present in the client's keychain.
   In the previous step the `host` was set to the common name of said certificate
7. `rustls` accepts the certificate, having verified that the common name matches the
   attacker-controlled value it was given
9. The client has been fooled by the MitM proxy into accepting the attacker-controlled certificate
