```toml
[advisory]
id = "RUSTSEC-2021-0031"
package = "nano_arena"
aliases = ["CVE-2021-28032", "GHSA-wp34-mqw5-jj85"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
date = "2021-01-31"
url = "https://github.com/bennetthardwick/nano-arena/issues/1"
categories = ["memory-corruption"]
keywords = ["memory-safety", "aliasing", "unsound"]

[versions]
patched = [">= 0.5.2"]

[affected.functions]
"nano_arena::Arena::split_at" = ["< 0.5.2"]
"nano_arena::ArenaSplit::split_at" = ["< 0.5.2"]
```

# split_at allows obtaining multiple mutable references to the same data

Affected versions of this crate assumed that `Borrow<Idx>` was guaranteed to
return the same value on `.borrow()`. The borrowed index value was used to
retrieve a mutable reference to a value.

If the `Borrow<Idx>` implementation returned a different index, the split arena
would allow retrieving the index as a mutable reference creating two mutable
references to the same element. This violates Rust's aliasing rules and allows
for memory safety issues such as writing out of bounds and use-after-frees.

The flaw was corrected in commit `6b83f9d` by storing the `.borrow()` value in
a temporary variable.
