```toml
[advisory]
id = "RUSTSEC-2020-0068"
package = "multihash"
aliases = ["CVE-2020-35909", "GHSA-h7qh-3h6f-w79p"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2020-11-08"
url = "https://github.com/multiformats/rust-multihash/pull/72"
categories = ["denial-of-service"]
keywords = ["parsing", "panic", "untrusted data"]

[affected.functions]
"multihash::digests::MultihashRefGeneric::from_slice" = ["< 0.11.3"]
"multihash::digests::MultihashGeneric::from_bytes" = ["< 0.11.3"]

[versions]
patched = [">= 0.11.3"]
unaffected = []
```

# Unexpected panic in multihash `from_slice` parsing code

In versions prior 0.11.3 it's possible to make `from_slice` panic by feeding it certain malformed input.
It's never documented that `from_slice` (and `from_bytes` which wraps it) can panic, and its' return type (`Result<Self, DecodeError>`) suggests otherwise.

In practice, `from_slice`/`from_bytes` is frequently used in networking code (for example [in rust-libp2p](https://github.com/libp2p/rust-libp2p/blob/7b415d5e7040e45c541f76f2c409e63d4d3249c6/core/src/peer_id.rs#L89)) and is being called with unsanitized data from untrusted sources.
This can allow attackers to cause DoS by causing an unexpected `panic` in the network client's code.
