```toml
[advisory]
id = "RUSTSEC-2020-0140"
package = "model"
date = "2020-11-10"
url = "https://github.com/spacejam/model/issues/3"
categories = ["thread-safety"]
informational = "unsound"
aliases = ["CVE-2020-36460", "GHSA-mxv6-q98x-h958"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:H/I:H/A:H"

[versions]
patched = []
```

# `Shared` can cause a data race

`Shared` data structure in `model` crate implements `Send` and `Sync` traits regardless of the inner type.
This allows safe Rust code to trigger a data race, which is undefined behavior in Rust.

Users are advised to treat `Shared` as an unsafe type.
It should not be used outside of the testing context,
and care must be taken so that the testing code does not have a data race
besides a race condition that is expected to be caught by the test.

Check [the Rustonomicon](https://doc.rust-lang.org/nomicon/races.html) for the difference between
a data race and a general race condition.
