```toml
[advisory]
id = "RUSTSEC-2024-0019"
package = "mio"
date = "2024-03-04"
url = "https://github.com/tokio-rs/mio/security/advisories/GHSA-r8w9-5wcg-vfj7"
aliases = ["CVE-2024-27308", "GHSA-r8w9-5wcg-vfj7"]

[affected]
os = ["windows"]
functions = { "mio::windows::NamedPipe::new" = [">= 0.7.2, <= 0.8.10"] }

[versions]
patched = [">= 0.8.11"]
unaffected = ["< 0.7.2"]
```

# Tokens for named pipes may be delivered after deregistration

## Impact

When using named pipes on Windows, mio will under some circumstances return invalid tokens that correspond to named pipes that have already been deregistered from the mio registry. The impact of this vulnerability depends on how mio is used. For some applications, invalid tokens may be ignored or cause a warning or a crash. On the other hand, for applications that store pointers in the tokens, this vulnerability may result in a use-after-free.

For users of Tokio, this vulnerability is serious and can result in a use-after-free in Tokio.

The vulnerability is Windows-specific, and can only happen if you are using named pipes. Other IO resources are not affected.

## Affected versions

This vulnerability has been fixed in mio v0.8.11.

All versions of mio between v0.7.2 and v0.8.10 are vulnerable.

Tokio is vulnerable when you are using a vulnerable version of mio AND you are using at least Tokio v1.30.0. Versions of Tokio prior to v1.30.0 will ignore invalid tokens, so they are not vulnerable.

## Workarounds

Vulnerable libraries that use mio can work around this issue by detecting and ignoring invalid tokens.

## Technical details

When an IO resource registered with mio has a readiness event, mio delivers that readiness event to the user using a user-specified token. Mio guarantees that when an IO resource is [deregistered](https://docs.rs/mio/latest/mio/struct.Registry.html#method.deregister), then it will never return the token for that IO resource again. However, for named pipes on windows, mio may sometimes deliver the token for a named pipe even though the named pipe has been previously deregistered.

This vulnerability was originally reported in the Tokio issue tracker: [tokio-rs/tokio#6369](https://github.com/tokio-rs/tokio/issues/6369)  
This vulnerability was fixed in: [tokio-rs/mio#1760](https://github.com/tokio-rs/mio/pull/1760)

Thank you to [@rofoun](https://github.com/rofoun) and [@radekvit](https://github.com/radekvit) for discovering and reporting this issue.
