```toml
[advisory]
id = "RUSTSEC-2020-0152"
package = "max7301"
date = "2020-12-18"
url = "https://github.com/edarc/max7301/issues/1"
categories = ["memory-corruption"]
keywords = ["concurrency"]
aliases = ["CVE-2020-36472", "GHSA-rmff-f8w9-c9rm"]
cvss = "CVSS:3.1/AV:N/AC:H/PR:N/UI:N/S:U/C:N/I:N/A:H"

[versions]
patched = [">= 0.2.0"]
```

# ImmediateIO and TransactionalIO can cause data races

The `ImmediateIO` and `TransactionalIO` types implement `Sync` for all contained
`Expander<EI>` types regardless of if the `Expander` itself is safe to use
across threads.

As the `IO` types allow retrieving the `Expander`, this can lead to non-thread
safe types being sent across threads as part of the `Expander` leading to data
races.
