```toml
[advisory]
id = "RUSTSEC-2022-0051"
package = "lz4-sys"
date = "2022-08-25"
url = "https://github.com/lz4/lz4/pull/972"
categories = ["memory-corruption"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
keywords = ["integer-overflow", "out-of-bounds"]
related = ["CVE-2021-3520"]
aliases = ["GHSA-9q5j-jm53-v7vr"]

[versions]
patched = [">= 1.9.4"]
```

# Memory corruption in liblz4

lz4-sys up to v1.9.3 bundles a version of liblz4 that is vulnerable to
[CVE-2021-3520](https://nvd.nist.gov/vuln/detail/CVE-2021-3520).

Attackers could craft a payload that triggers an integer overflow upon
decompression, causing an out-of-bounds write.

The flaw has been corrected in version v1.9.4 of liblz4, which is included
in lz4-sys 1.9.4.
