```toml
[advisory]
id = "RUSTSEC-2018-0021"
package = "libpulse-binding"
date = "2018-06-15"
url = "https://github.com/jnqnfe/pulse-binding-rust/security/advisories/GHSA-ghpq-vjxw-ch5w"
categories = ["memory-corruption"]
aliases = ["CVE-2018-25027", "CVE-2018-25028", "GHSA-ghpq-vjxw-ch5w", "GHSA-hxjf-h2mh-r6hj", "GHSA-jqpv-jm4m-86j9"]

[versions]
patched = [">= 1.2.1"]

[affected.functions]
"libpulse_binding::stream::Stream::get_format_info" = ["< 1.2.1"]
"libpulse_binding::stream::Stream::get_context" = ["< 1.2.1"]
```

# Use-after-free with objects returned by `Stream`'s `get_format_info` and `get_context` methods

Affected versions contained a pair of use-after-free issues with the objects returned by the `get_format_info` and `get_context` methods of `Stream` objects. These objects were mistakenly being constructed without setting an important flag to prevent destruction of the underlying C objects they reference upon their own destruction.
