```toml
[advisory]
id = "RUSTSEC-2023-0086"
package = "lexical-core"
date = "2023-09-03"
informational = "unsound"
references = ["https://github.com/Alexhuszagh/rust-lexical/issues/102", "https://github.com/Alexhuszagh/rust-lexical/issues/101", "https://github.com/Alexhuszagh/rust-lexical/issues/95", "https://github.com/Alexhuszagh/rust-lexical/issues/104", "https://github.com/Alexhuszagh/rust-lexical/issues/126"]
related = ["RUSTSEC-2023-0055"]

[versions]
patched = [">= 1.0.0"]
```

# Multiple soundness issues

`RUSTSEC-2024-0377` contains multiple soundness issues:

 1. [Bytes::read() allows creating instances of types with invalid bit patterns](https://github.com/Alexhuszagh/rust-lexical/issues/102)
 1. [BytesIter::read() advances iterators out of bounds](https://github.com/Alexhuszagh/rust-lexical/issues/101)
 1. [The `BytesIter` trait has safety invariants but is public and not marked `unsafe`](https://github.com/Alexhuszagh/rust-lexical/issues/104)
 1. [`write_float()` calls `MaybeUninit::assume_init()` on uninitialized data, which is is not allowed by the Rust abstract machine](https://github.com/Alexhuszagh/rust-lexical/issues/95)
 1. [`radix()` calls `MaybeUninit::assume_init()` on uninitialized data, which is is not allowed by the Rust abstract machine](https://github.com/Alexhuszagh/rust-lexical/issues/126)

Version 1.0 fixes these issues, removes the vast majority of `unsafe` code, and also fixes some correctness issues.
