```toml
[advisory]
id = "RUSTSEC-2016-0002"
package = "hyper"
date = "2016-05-09"
aliases = ["CVE-2016-10932", "GHSA-9xjr-m6f3-v5wm"]
cvss = "CVSS:3.0/AV:N/AC:H/PR:N/UI:N/S:U/C:L/I:L/A:N"
related = ["RUSTSEC-2016-0001"]
categories = ["crypto-failure"]
keywords = ["ssl", "mitm"]
url = "https://github.com/hyperium/hyper/blob/master/CHANGELOG.md#v094-2016-05-09"

[affected]
os = ["windows"]

[versions]
patched = [">= 0.9.4"]
```

# HTTPS MitM vulnerability due to lack of hostname verification

When used on Windows platforms, all versions of Hyper prior to 0.9.4 did not
perform hostname verification when making HTTPS requests.

This allows an attacker to perform MitM attacks by preventing any valid
CA-issued certificate, even if there's a hostname mismatch.

The problem was addressed by leveraging rust-openssl's built-in support for
hostname verification.
