```toml
[advisory]
id = "RUSTSEC-2024-0335"
package = "gix-transport"
date = "2024-04-13"
url = "https://github.com/Byron/gitoxide/security/advisories/GHSA-98p4-xjmm-8mfh"
categories = ["code-execution"]
aliases = ["CVE-2024-32884", "GHSA-98p4-xjmm-8mfh"]

[versions]
patched = [">= 0.42.0"]
```

# gix-transport indirect code execution via malicious username

### Summary

`gix-transport` does not check the username part of a URL for text that the external `ssh` program would interpret as an option. A specially crafted clone URL can smuggle options to SSH. The possibilities are syntactically limited, but if a malicious clone URL is used by an application whose current working directory contains a malicious file, arbitrary code execution occurs.

The first `gix` crate with the fix [is version 0.62.0](https://crates.io/crates/gix/0.62.0), and the first fixed `gix` CLI is [version 0.35](https://github.com/Byron/gitoxide/releases/tag/v0.35.0). `gix-transport` [at version v0.42](https://crates.io/crates/gix-transport/0.42.0) is the lowest-level plumbing crate with the fix.

### Details

This is related to the patched vulnerability [RUSTSEC-2023-0064](https://rustsec.org/advisories/RUSTSEC-2023-0064.html), but appears less severe due to a greater attack complexity. Since <https://github.com/Byron/gitoxide/pull/1032>, `gix-transport` checks the host and path portions of a URL for text that has a `-` in a position that will cause `ssh` to interpret part of all of the URL as an option argument. But it does not check the non-mandatory username portion of the URL.

As in Git, when an address is a URL of the form `ssh://username@hostname/path`, or when it takes the special form `username@hostname:dirs/repo`, this is treated as an SSH URL. `gix-transport` will replace some characters in `username` with their `%`-based URL encodings, but otherwise passes `username@hostname` as an argument to the external `ssh` command. This happens even if `username` begins with a hyphen. In that case, `ssh` treats that argument as an option argument, and attempts to interpret and honor it as a sequence of one or more options possibly followed by an operand for the last option.

This is harder to exploit than [RUSTSEC-2023-0064](https://rustsec.org/advisories/RUSTSEC-2023-0064.html), because the possibilities are constrained by:

- The difficulty of forming an option argument `ssh` accepts, given that characters such as `=`, `/`, and `\`, are URL-encoded, `:` is removed, and the argument passed to `ssh` contains the `@` sign and subsequent host identifier, which in an effective attack must be parseable as a suffix of the operand passed to the last option.

  The inability to include a literal `=` prevents the use of `-oNAME=VALUE` (e.g., `-oProxyCommand=payload`). The inability to include a literal `/` or `\` prevents smuggling in a path operand residing outside the current working directory, including on Windows. (Although a `~` character may be smuggled in, `ssh` does not perform its own tilde expansion, so it does not form an absolute path.)

- The difficulty, or perhaps impossibility, of completing a connection (other than when arbitrary code execution has been achieved). This complicates or altogether prevents the use of options such as `-A` and `-X` together with a connection to a real but malicious server. The reason a connection cannot generally be completed when exploiting this vulnerability is that, because the argument `gix-transport` intends as a URL is treated as an option argument, `ssh` treats the subsequent non-option argument `git-upload-pack` as the host instead of the command, but it is not a valid host name.

  Although `ssh` supports aliases for hosts, even if `git-upload-pack` could be made an alias, that is made difficult by the URL-encoding transformation.

However, an attacker who is able to cause a specially named `ssh` configuration file to be placed in the current working directory can smuggle in an `-F` option referencing the file, and this allows arbitrary command execution.

This scenario is especially plausible because programs that operate on git repositories are often run in untrusted git repositories, sometimes even to operate on another repository. Situations where this is likely, such that an attacker could predict or arrange it, may for some applications include a malicious repository with a malicious submodule configuration.

Other avenues of exploitation exist, but appear to be less severe. For example, the `-E` option can be smuggled to create or append to a file in the current directory (or its target, if it is a symlink). There may also be other significant ways to exploit this that have not yet been discovered, or that would arise with new options in future versions of `ssh`.

### PoC

To reproduce the known case that facilitates arbitrary code execution, first create a file in the current directory named `configfile@example.com`, of the form

```text
ProxyCommand payload
```

where `payload` is a command with an observable side effect. On Unix-like systems, this could be `date | tee vulnerable` or an `xdg-open`, `open`, or other command command to launch a graphical application. On Windows, this could be the name of a graphical application already in the search path, such as `calc.exe`.

(Although the syntax permitted in the value of `ProxyCommand` may vary by platform, this is not limited to running commands in the current directory. That limitation only applies to paths directly smuggled in the username, not to the contents of a separate malicious configuration file. Arbitrary other settings may be specified in `configfile@example.com` as well.)

Then run:

```sh
gix clone 'ssh://-Fconfigfile@example.com/abc'
```

Or:

```sh
gix clone -- '-Fconfigfile@example.com:abc/def'
```

(The `--` is required to ensure that `gix` is really passing the argument as a URL for use in `gix-transport`, rather than interpreting it as an option itself, which would not necessarily be a vulnerability.)

In either case, the payload specified in `configfile@example.com` runs, and its side effect can be observed.

Other cases may likewise be produced, in either of the above two forms of SSH addresses. For example, to create or append to the file `errors@example.com`, or to create or append to its target if it is a symlink:

```sh
gix clone 'ssh://-Eerrors@example.com/abc'
```

```sh
gix clone -- '-Eerrors@example.com:abc/def'
```

### Impact

As in [RUSTSEC-2023-0064](https://rustsec.org/advisories/RUSTSEC-2023-0064.html), this would typically require user interaction to trigger an attempt to clone or otherwise connect using the malicious URL. Furthermore, known means of exploiting this vulnerability to execute arbitrary commands require further preparatory steps to establish a specially named file in the current directory. The impact is therefore expected to be lesser, though it is difficult to predict it with certainty because it is not known exactly what scenarios will arise when using the `gix-transport` library.

Users who use applications that make use of `gix-transport` are potentially vulnerable, especially:

- On repositories with submodules that are automatically added, depending how the application manages submodules.
- When operating on other repositories from inside an untrusted repository.
- When reviewing contributions from untrusted developers by checking out a branch from an untrusted fork and performing clones from that location.

