```toml
[advisory]
id = "RUSTSEC-2024-0355"
package = "gix-path"
date = "2024-07-18"
url = "https://github.com/Byron/gitoxide/security/advisories/GHSA-mgvv-9p9g-3jv4"
references = ["https://github.com/advisories/GHSA-mgvv-9p9g-3jv4"]
categories = ["code-execution", "privilege-escalation"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:R/S:U/C:H/I:H/A:L"
keywords = ["search-path"]
aliases = ["CVE-2024-40644", "GHSA-mgvv-9p9g-3jv4"]
license = "CC0-1.0"

[affected]
os = ["windows"]

[affected.functions]
"gix_path::env::exe_invocation" = ["*"]
"gix_path::env::installation_config" = ["*"]
"gix_path::env::installation_config_prefix" = ["*"]
"gix_path::env::system_prefix" = ["*"]

[versions]
patched = [">= 0.10.9"]
unaffected = ["< 0.10.8"]
```

# gix-path can use a fake program files location

### Summary

When looking for Git for Windows so it can run it to report its paths, `gix-path` can be tricked into running another `git.exe` placed in an untrusted location by a limited user account.

### Details

Windows permits limited user accounts without administrative privileges to create new directories in the root of the system drive. While `gix-path` first looks for `git` using a `PATH` search, in version 0.10.8 it also has a fallback strategy on Windows of checking [two hard-coded paths](https://github.com/Byron/gitoxide/blob/6cd8b4665bb7582f744c3244abaef812be39ec35/gix-path/src/env/git.rs#L9-L14) intended to be the 64-bit and 32-bit Program Files directories:

```rust
/// Other places to find Git in.
#[cfg(windows)]
pub(super) static ALTERNATIVE_LOCATIONS: &[&str] = &[
    "C:/Program Files/Git/mingw64/bin",
    "C:/Program Files (x86)/Git/mingw32/bin",
];
```

Existing functions, as well as the newly introduced `exe_invocation` function, were updated to make use of these alternative locations. This causes facilities in `gix_path::env` to directly execute `git.exe` in those locations, as well as to return its path or whatever configuration it reports to callers who rely on it.

Although unusual setups where the system drive is not `C:`, or even where Program Files directories have non-default names, are technically possible, the main problem arises on a 32-bit Windows system. Such a system has no `C:\Program Files (x86)` directory.

A limited user on a 32-bit Windows system can therefore create the `C:\Program Files (x86)` directory and populate it with arbitrary contents. Once a payload has been placed at the second of the two hard-coded paths in this way, other user accounts including administrators will execute it if they run an application that uses `gix-path` and do not have `git` in a `PATH` directory.

(While having `git` found in a `PATH` search prevents exploitation, merely having it installed in the default location under the real `C:\Program Files` directory does not. This is because the first hard-coded path's `mingw64` component assumes a 64-bit installation.)

### PoC

On a 32-bit (x86) Windows 10 system, with or without Git for Windows installed:

1. Create a limited user account in `lusrmgr.msc` or the Settings application.
2. Log in with that account and, using Windows Explorer or the `mkdir` command in PowerShell, create the directories `C:\Program Files (x86)\Git\mingw32\bin`. Although a limited user account cannot create regular files directly in `C:\`, it can create directories including one called `Program Files (x86)`.
3. Place a copy of `C:\Windows\system32\calc.exe` in `C:\Program Files (x86)\Git\mingw32\bin` and rename it from `calc.exe` to `git.exe`. A different test payload may be used if preferred, and the executable need not already be signed or trusted.
4. Log out, and log in as a different user. This user may be an administrator.
5. If `gitoxide` is not installed, install it. If `cargo install gitoxide` is used for the installation, then the version of `gix-path` used in the installation can be observed.
6. The vulnerability is only exploitable if `git` cannot be found in a `PATH` search. So, in PowerShell, run `gcm git` to check if `git` is present in the `PATH`. If so, temporarily remove it. One way to do this is for the current shell only, by running `$env:PATH` to inspect it and by assigning `$env:PATH = '...'` where `...` omits directories that contain `git`.
7. Some commands that can be run outside a repository, and most commands that can be run inside a repository, will run the Calculator or other payload at least once per invocation. Try `gix clone foo` or, inside of a repository, `gix status`, `gix config`, `gix is-changed`, `gix fetch`, `ein t hours`, or `ein t query`. This is not exhaustive; most other `gix` and `ein` commands that access existing repository state or a network resource likewise run the payload.

### Impact

Only Windows is affected. Exploitation is unlikely except on a 32-bit system. In particular, running a 32-bit build on a 64-bit system is not a risk factor. Furthermore, the attacker must have a user account on the system, though it may be a relatively unprivileged account. Such a user can perform privilege escalation and execute code as another user, though it may be difficult to do so reliably because the targeted user account must run an application or service that uses `gix-path` and must not have `git` in its `PATH`.

The main exploitable configuration is one where Git for Windows has been installed but not added to `PATH`. This is one of the options in its installer, though not the default option. Alternatively, an affected program that sanitizes its `PATH` to remove seemingly nonessential directories could allow exploitation. But for the most part, if the target user has configured a `PATH` in which the real `git.exe` can be found, then this cannot be exploited.

This vulnerability is comparable to [CVE-2022-24765](https://github.com/git-for-windows/git/security/advisories/GHSA-vw2c-22j4-2fh2), in which an uncontrolled path like `C:\.git\config`, which a limited user can create, could supply configuration used by other users. However, in this case, exploitation is slightly simpler because, rather than using configuration, an executable is directly run.
