```toml
[advisory]
id = "RUSTSEC-2021-0091"
package = "gfx-auxil"
date = "2021-01-07"
url = "https://github.com/gfx-rs/gfx/issues/3567"
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45689", "GHSA-28p5-7rg4-8v99", "GHSA-ff2r-xpwq-6whj"]

[versions]
patched = []
```

# Reading on uninitialized buffer may cause UB ( `gfx_auxil::read_spirv()` )

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation.

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.
