```toml
[advisory]
id = "RUSTSEC-2020-0072"
package = "futures-intrusive"
aliases = ["CVE-2020-35915", "GHSA-4hjg-cx88-g9f9"]
cvss = "CVSS:3.1/AV:L/AC:L/PR:L/UI:N/S:U/C:N/I:N/A:H"
date = "2020-10-31"
url = "https://github.com/Matthias247/futures-intrusive/issues/53"
categories = ["memory-corruption", "thread-safety"]
keywords = ["concurrency"]
informational = "unsound"

[versions]
patched = [">= 0.4.0"]
```

# GenericMutexGuard allows data races of non-Sync types across threads

`GenericMutexGuard<T>` was given the `Sync` auto trait as long as `T` is `Send`
due to its contained members. However, since the guard is supposed to represent
an **acquired lock** and allows concurrent access to the underlying data from
different threads, it should only be `Sync` when the underlying data is.

This is a soundness issue and allows data races, potentially leading to crashes
and segfaults from safe Rust code.

The flaw was corrected by adding a `T: Send + Sync` bound for
`GenericMutexGuard`'s `Sync` trait.

This bug is [similar to one](https://github.com/rust-lang/rust/issues/41622) in
`std::sync::Mutex`.
