```toml
[advisory]
id = "RUSTSEC-2021-0086"
package = "flumedb"
date = "2021-01-07"
url = "https://github.com/sunrise-choir/flumedb-rs/issues/10"
references = ["https://github.com/sunrise-choir/flumedb-rs/pull/12"]
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45684", "GHSA-p46c-w9m3-7qr2", "GHSA-p56p-gq3f-whg8"]

[versions]
patched = [">=0.1.6"]
```

# `Read` on uninitialized buffer may cause UB ( `read_entry()` )

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation.
There are two of such cases (`go_offset_log::read_entry()` & `offset_log::read_entry()`).

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.
