```toml
[advisory]
id = "RUSTSEC-2021-0038"
package = "fltk"
aliases = ["CVE-2021-28306", "CVE-2021-28307", "CVE-2021-28308", "GHSA-5pg8-h4gv-m3p8", "GHSA-7qcc-g2m9-8533", "GHSA-vjmg-pc8h-p6p8"]
date = "2021-03-06"
keywords = ["undefined_behavior"]
url = "https://github.com/MoAlyousef/fltk-rs/issues/519"

[affected.functions]
"fltk::prelude::WidgetExt::set_label_type" = ["< 0.15.2"]
"fltk::prelude::WindowExt::set_icon" = ["< 0.14.12"]
"fltk::image::Pixmap::new" = ["< 0.15.2, >= 0.14.12"]

[versions]
patched = [">= 0.15.3"]
```

# Multiple memory safety issues

Affected versions contain multiple memory safety issues, such as:

 - Setting a multi label type where an image doesn't exist would lead to a NULL pointer dereference.
 - Setting a window icon using a non-raster image (which FLTK rasterizes lazily) would lead to a NULL dereference.
 - Pixmap constructor would not check for correct pixmaps which could lead to out-of bound reads.
