```toml
[advisory]
id = "RUSTSEC-2025-0002"
package = "fast-float2"
date = "2025-01-13"
url = "https://github.com/aldanor/fast-float-rust/issues/38"
categories = ["memory-exposure"]

[affected]
functions = { "fast_float2::common::AsciiStr::first" = ["<0.2.2"] }

[versions]
patched = [">=0.2.2"]
```
# Segmentation fault due to lack of bound check
In this case, the "fast_float2::common::AsciiStr::first" method within the "AsciiStr" struct 
uses the unsafe keyword to reading from memory without performing bounds checking. 
Specifically, it directly dereferences a pointer offset by "self.ptr".
Because of the above reason, the method accesses invalid memory address when it takes an empty string as its input.
This approach violates Rust’s memory safety guarantees, as it can lead to invalid memory access if empty buffer is provided.
