```toml
[advisory]
id = "RUSTSEC-2021-0088"
package = "csv-sniffer"
date = "2021-01-05"
url = "https://github.com/jblondin/csv-sniffer/issues/1"
references = ["https://github.com/jblondin/csv-sniffer/pull/2"]
categories = ["memory-exposure"]
informational = "unsound"
aliases = ["CVE-2021-45686", "GHSA-9783-42pm-x5jq", "GHSA-r67p-m7g9-gxw6"]

[versions]
patched = [">= 0.2.0"]
```

# `Read` on uninitialized memory may cause UB (fn preamble_skipcount())

Affected versions of this crate passes an uninitialized buffer to a user-provided `Read` implementation (within `fn preamble_skipcount()`).

Arbitrary `Read` implementations can read from the uninitialized buffer (memory exposure) and also can return incorrect number of bytes written to the buffer.
Reading from uninitialized memory produces undefined values that can quickly invoke undefined behavior.
