```toml
[advisory]
id = "RUSTSEC-2022-0020"
package = "crossbeam"
date = "2022-05-10"
informational = "unsound"
url = "https://github.com/crossbeam-rs/crossbeam/pull/458"
aliases = ["GHSA-8gj8-hv75-gp94"]

[versions]
patched = [">= 0.7.0"]
```

# `SegQueue` creates zero value of any type

Affected versions of this crate called `mem::zeroed()` to create values of a user-supplied type `T`.
This is unsound e.g. if `T` is a reference type (which must be non-null).
 
The flaw was corrected by avoiding the use of `mem::zeroed()`, using `MaybeUninit` instead.
