```toml
[advisory]
id = "RUSTSEC-2021-0093"
package = "crossbeam-deque"
aliases = ["GHSA-pqqp-xmhj-wgcw", "CVE-2021-32810"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2021-07-30"
url = "https://github.com/crossbeam-rs/crossbeam/security/advisories/GHSA-pqqp-xmhj-wgcw"

[versions]
patched = [">= 0.7.4, < 0.8.0", ">= 0.8.1"]
```

# Data race in crossbeam-deque

In the affected version of this crate, the result of the race condition is that one or more tasks in the worker queue can be popped twice instead of other tasks that are forgotten and never popped. If tasks are allocated on the heap, this can cause double free and a memory leak. If not, this still can cause a logical bug.

Crates using `Stealer::steal`, `Stealer::steal_batch`, or `Stealer::steal_batch_and_pop` are affected by this issue.

Credits to @kmaork for discovering, reporting and fixing the bug.
