```toml
[advisory]
id = "RUSTSEC-2024-0366"
package = "cosmwasm-vm"
date = "2024-08-27"
url = "https://github.com/CosmWasm/advisories/blob/main/CWAs/CWA-2023-004.md"
categories = ["denial-of-service"]
keywords = ["resource-consumption", "crash", "deadlock"]

[versions]
patched = [">= 1.2.8, < 1.3.0", ">= 1.3.4, < 1.4.0", ">= 1.4.2, < 1.5.0", ">= 1.5.1"]
```

# CWA-2023-004: Excessive number of function parameters in compiled Wasm

A specifically crafted Wasm file can cause the VM to consume excessive amounts of memory when compiling a contract.
This can lead to high memory usage, slowdowns, potentially a crash and can poison a lock in the VM,
preventing any further interaction with contracts.

For more information, see [CWA-2023-004](https://github.com/CosmWasm/advisories/blob/main/CWAs/CWA-2023-004.md).
