```toml
[advisory]
id = "RUSTSEC-2021-0132"
package = "compu-brotli-sys"
date = "2021-12-20"
url = "https://github.com/google/brotli/releases/tag/v1.0.9"
categories = ["memory-corruption"]
keywords = ["integer-overflow"]
aliases = ["CVE-2020-8927", "GHSA-5v8v-66v8-mwm7"]

[affected]

[versions]
patched = [">= 1.0.9"]
```

# Integer overflow in the bundled Brotli C library

A buffer overflow exists in the Brotli library versions prior to 1.0.8 where an attacker controlling the input length of a "one-shot" decompression request to a script can trigger a crash, which happens when copying over chunks of data larger than 2 GiB.

If one cannot update the C library, its authors recommend to use the "streaming" API as opposed to the "one-shot" API, and impose chunk size limits.
