```toml
[advisory]
id = "RUSTSEC-2020-0159"
package = "chrono"
date = "2020-11-10"
url = "https://github.com/chronotope/chrono/issues/499"
categories = ["code-execution", "memory-corruption"]
keywords = ["segfault"]
related = ["CVE-2020-26235", "RUSTSEC-2020-0071"]

[versions]
patched = [">=0.4.20"]
```

# Potential segfault in `localtime_r` invocations

### Impact

Unix-like operating systems may segfault due to dereferencing a dangling pointer in specific circumstances. This requires an environment variable to be set in a different thread than the affected functions. This may occur without the user's knowledge, notably in a third-party library.

### Workarounds

No workarounds are known.

### References

- [time-rs/time#293](https://github.com/time-rs/time/issues/293)
