```toml
[advisory]
id = "RUSTSEC-2022-0017"
package = "array-macro"
date = "2022-04-27"
url = "https://gitlab.com/KonradBorowski/array-macro/-/issues/5"
categories = ["code-execution", "memory-corruption", "memory-exposure"]
informational = "unsound"
aliases = ["GHSA-7v4j-8wvr-v55r"]

[versions]
patched = [">= 2.1.2"]
unaffected = ["< 2.1.0"]
```

# `array!` macro is unsound when its length is impure constant

Affected versions of this crate did substitute the array length provided by an user at compile-time multiple times.

When an impure constant expression is passed as an array length (such as a result of an impure procedural macro), this can result in the initialization of an array with uninitialized types, which in turn can allow an attacker to execute arbitrary code.

The flaw was corrected in commit [d5b63f72](https://gitlab.com/KonradBorowski/array-macro/-/commit/d5b63f72090f3809c21ac28f9cfd84f12559bf7d) by making sure that array length is substituted just once.
