```toml
[advisory]
id = "RUSTSEC-2020-0034"
package = "arr"
aliases = ["CVE-2020-35886", "CVE-2020-35887", "CVE-2020-35888", "GHSA-36xw-hgfv-jwm7", "GHSA-c7fw-cr3w-wvfc", "GHSA-fhvj-7f9p-w788"]
date = "2020-08-25"
url = "https://github.com/sjep/array/issues/1"
categories = ["memory-corruption", "thread-safety"]

[versions]
patched = []
```

# Multiple security issues including data race, buffer overflow, and uninitialized memory drop

`arr` crate contains multiple security issues. Specifically,

1. It incorrectly implements Sync/Send bounds, which allows to smuggle non-Sync/Send types across the thread boundary.
2. `Index` and `IndexMut` implementation does not check the array bound.
3. `Array::new_from_template()` drops uninitialized memory.
