```toml
[advisory]
id = "RUSTSEC-2024-0404"
package = "anstream"
date = "2024-09-08"
url = "https://github.com/rust-cli/anstyle/issues/156"
informational = "unsound"

[affected]
functions = { "anstream::adapter::strip_str" = ["< 0.6.8"] }

[versions]
patched = [">= 0.6.8"]

```

# Unsoundness in anstream

When given a valid UTF8 string "ö\x1b😀", the function in
crates/anstream/src/adapter/strip.rs will be confused. The UTF8
bytes are \xc3\xb6 then \x1b then \xf0\x9f\x98\x80.

When looping over "non-printable bytes" \x1b\xf0 will be
considered as some non-printable sequence.

This will produce a broken str from the incorrectly segmented
bytes via str::from_utf8_unchecked, and that should never happen.

Full credit goes to @Ralith who reviewed this code and
asked @burakemir to follow up.
