```toml
[advisory]
id = "RUSTSEC-2019-0001"
package = "ammonia"
aliases = ["CVE-2019-15542", "GHSA-5hp8-35wj-m525"]
cvss = "CVSS:3.0/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:N/A:H"
date = "2019-04-27"
keywords = ["stack-overflow", "crash"]
url = "https://github.com/rust-ammonia/ammonia/blob/master/CHANGELOG.md#210"

[affected.functions]
"ammonia::Document::to_string" = ["< 2.1.0"]
"ammonia::Document::write_to" = ["< 2.1.0"]
"ammonia::clean" = ["< 2.1.0"]

[versions]
patched = [">= 2.1.0"]
```

# Uncontrolled recursion leads to abort in HTML serialization

Affected versions of this crate did use recursion for serialization of HTML
DOM trees.

This allows an attacker to cause abort due to stack overflow by providing
a pathologically nested input.

The flaw was corrected by serializing the DOM tree iteratively instead.
