```toml
[advisory]
id = "RUSTSEC-2020-0045"
package = "actix-utils"
aliases = ["CVE-2020-35898", "GHSA-hhw2-pqhf-vmx2"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:N/I:H/A:H"
categories = ["memory-corruption"]
date = "2020-01-08"
informational = "unsound"
url = "https://github.com/actix/actix-net/issues/160"

[versions]
patched = [">= 2.0.0"]
```

# bespoke Cell implementation allows obtaining several mutable references to the same data

The custom implementation of a Cell primitive in the affected versions of this crate
does not keep track of mutable references to the underlying data.

This allows obtaining several mutable references to the same object
which may result in arbitrary memory corruption, most likely use-after-free.

The flaw was corrected by switching from a bespoke `Cell<T>` implementation to `Rc<RefCell<T>>`.
