```toml
[advisory]
id = "RUSTSEC-2020-0049"
package = "actix-codec"
aliases = ["CVE-2020-35902", "GHSA-rqgx-hpg4-456r"]
cvss = "CVSS:3.1/AV:N/AC:L/PR:N/UI:N/S:U/C:H/I:H/A:H"
categories = ["memory-corruption"]
date = "2020-01-30"
url = "https://github.com/actix/actix-net/issues/91"

[versions]
patched = [">= 0.3.0-beta.1"]
```

# Use-after-free in Framed due to lack of pinning

Affected versions of this crate did not require the buffer wrapped in `Framed` to be pinned,
but treated it as if it had a fixed location in memory. This may result in a use-after-free.
 
The flaw was corrected by making the affected functions accept `Pin<&mut Self>` instead of `&mut self`.
