/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.error;

import static java.lang.String.format;
import static org.assertj.core.api.BDDAssertions.then;
import static org.assertj.core.error.NoElementsShouldMatch.noElementsShouldMatch;
import static org.assertj.core.util.Lists.list;

import org.assertj.core.description.TextDescription;
import org.assertj.core.presentation.PredicateDescription;
import org.assertj.core.presentation.StandardRepresentation;
import org.junit.jupiter.api.Test;

/**
 * @author Filip Hrisafov
 */
class NoElementsShouldMatch_create_Test {

  @Test
  void should_create_error_message() {
    // GIVEN
    ErrorMessageFactory factory = noElementsShouldMatch(list("Luke", "Yoda"), "Yoda",
                                                        PredicateDescription.GIVEN);
    // WHEN
    String message = factory.create(new TextDescription("Test"), new StandardRepresentation());
    // THEN
    then(message).isEqualTo(format("[Test] %n" +
                                   "Expecting no elements of:%n" +
                                   "  [\"Luke\", \"Yoda\"]%n" +
                                   "to match given predicate but this element did:%n" +
                                   "  \"Yoda\""));
  }

  @Test
  void should_create_error_message_with_custom_description() {
    // GIVEN
    ErrorMessageFactory factory = noElementsShouldMatch(list("Luke", "Yoda"), "Yoda",
                                                        new PredicateDescription("custom"));
    // WHEN
    String message = factory.create(new TextDescription("Test"), new StandardRepresentation());
    // THEN
    then(message).isEqualTo(format("[Test] %n" +
                                   "Expecting no elements of:%n" +
                                   "  [\"Luke\", \"Yoda\"]%n" +
                                   "to match 'custom' predicate but this element did:%n" +
                                   "  \"Yoda\""));
  }

}
