/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.condition;

import static org.assertj.core.api.Assertions.assertThat;

import java.util.Collection;

import org.assertj.core.api.Condition;
import org.assertj.core.api.TestCondition;
import org.assertj.core.util.Lists;
import org.junit.jupiter.api.Test;

/**
 * Tests for <code>{@link AnyOf#anyOf(Condition...)}</code>.
 * 
 * @author Yvonne Wang
 */
class AnyOf_anyOf_with_Collection_Test {

  @Test
  void should_create_new_AnyOf_with_passed_Conditions() {
    Collection<Condition<Object>> conditions = Lists.newArrayList(new TestCondition<>());
    Condition<Object> created = AnyOf.anyOf(conditions);
    assertThat(created.getClass()).isEqualTo(AnyOf.class);
    AnyOf<Object> anyOf = (AnyOf<Object>) created;
    assertThat(anyOf.conditions).isEqualTo(conditions);
  }
}
