/*
 * Copyright 2012-2026 the original author or authors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.assertj.core.api.atomic.reference;

import static org.assertj.core.api.Assertions.assertThat;
import static org.assertj.core.api.BDDAssertions.then;
import static org.assertj.core.error.ShouldNotContainValue.shouldNotContainValue;
import static org.assertj.core.util.AssertionsUtil.expectAssertionError;

import java.util.concurrent.atomic.AtomicReference;

import org.junit.jupiter.api.Test;

class AtomicReferenceAssert_doesNotHaveNullValue_Test {

  @Test
  void should_pass_when_actual_does_not_have_the_null_value() {
    // GIVEN
    AtomicReference<String> actual = new AtomicReference<>("foo");
    // WHEN/THEN
    then(actual).doesNotHaveNullValue();
  }

  @Test
  void should_fail_when_actual_has_the_null_value() {
    // GIVEN
    AtomicReference<String> actual = new AtomicReference<>(null);
    // WHEN
    AssertionError assertionError = expectAssertionError(() -> assertThat(actual).doesNotHaveNullValue());
    // THEN
    then(assertionError).hasMessage(shouldNotContainValue(actual, null).create());
  }
}
