/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.resolver;

import fr.jayasoft.ivy.Artifact;
import fr.jayasoft.ivy.DependencyDescriptor;
import fr.jayasoft.ivy.DependencyResolver;
import fr.jayasoft.ivy.Ivy;
import fr.jayasoft.ivy.IvyAware;
import fr.jayasoft.ivy.IvyNode;
import fr.jayasoft.ivy.LatestStrategy;
import fr.jayasoft.ivy.ModuleDescriptor;
import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.ResolveData;
import fr.jayasoft.ivy.ResolvedModuleRevision;
import fr.jayasoft.ivy.namespace.NameSpaceHelper;
import fr.jayasoft.ivy.namespace.Namespace;
import fr.jayasoft.ivy.report.ArtifactDownloadReport;
import fr.jayasoft.ivy.report.DownloadReport;
import fr.jayasoft.ivy.report.DownloadStatus;
import fr.jayasoft.ivy.resolver.HasLatestStrategy;
import fr.jayasoft.ivy.resolver.ModuleEntry;
import fr.jayasoft.ivy.resolver.OrganisationEntry;
import fr.jayasoft.ivy.resolver.RevisionEntry;
import fr.jayasoft.ivy.util.Message;

public abstract class AbstractResolver
implements DependencyResolver,
IvyAware,
HasLatestStrategy {
    private Boolean _validate = null;
    private String _name;
    private Ivy _ivy;
    private LatestStrategy _latestStrategy;
    private String _latestStrategyName;
    private Namespace _namespace;
    private String _namespaceName;

    public Ivy getIvy() {
        return this._ivy;
    }

    public void setIvy(Ivy ivy) {
        this._ivy = ivy;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    protected boolean doValidate(ResolveData data) {
        if (this._validate != null) {
            return this._validate;
        }
        return data.isValidate();
    }

    public boolean isValidate() {
        return this._validate == null ? true : this._validate;
    }

    public void setValidate(boolean validate) {
        this._validate = validate;
    }

    public void reportFailure() {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    public void reportFailure(Artifact art) {
        Message.verbose("no failure report implemented by " + this.getName());
    }

    public OrganisationEntry[] listOrganisations() {
        return new OrganisationEntry[0];
    }

    public ModuleEntry[] listModules(OrganisationEntry org) {
        return new ModuleEntry[0];
    }

    public RevisionEntry[] listRevisions(ModuleEntry module) {
        return new RevisionEntry[0];
    }

    public String toString() {
        return this.getName();
    }

    public void dumpConfig() {
        Message.verbose("\t" + this.getName() + " [" + this.getTypeName() + "]");
    }

    public String getTypeName() {
        return this.getClass().getName();
    }

    public boolean exists(Artifact artifact) {
        DownloadReport dr = this.download(new Artifact[]{artifact}, this.getIvy(), this.getIvy().getDefaultCache());
        ArtifactDownloadReport adr = dr.getArtifactReport(artifact);
        return adr.getDownloadStatus() != DownloadStatus.FAILED;
    }

    public LatestStrategy getLatestStrategy() {
        if (this._latestStrategy == null) {
            if (this.getIvy() != null) {
                if (this._latestStrategyName != null && !"default".equals(this._latestStrategyName)) {
                    this._latestStrategy = this.getIvy().getLatestStrategy(this._latestStrategyName);
                    if (this._latestStrategy == null) {
                        Message.error("unknown latest strategy: " + this._latestStrategyName);
                        this._latestStrategy = this.getIvy().getDefaultLatestStrategy();
                    }
                } else {
                    this._latestStrategy = this.getIvy().getDefaultLatestStrategy();
                    Message.debug(this.getName() + ": no latest strategy defined: using default");
                }
            } else {
                throw new IllegalStateException("no ivy instance found: impossible to get a latest strategy without ivy instance");
            }
        }
        return this._latestStrategy;
    }

    public void setLatestStrategy(LatestStrategy latestStrategy) {
        this._latestStrategy = latestStrategy;
    }

    public void setLatest(String strategyName) {
        this._latestStrategyName = strategyName;
    }

    public String getLatest() {
        if (this._latestStrategyName == null) {
            this._latestStrategyName = "default";
        }
        return this._latestStrategyName;
    }

    public Namespace getNamespace() {
        if (this._namespace == null) {
            if (this.getIvy() != null) {
                if (this._namespaceName != null) {
                    this._namespace = this.getIvy().getNamespace(this._namespaceName);
                    if (this._namespace == null) {
                        Message.error("unknown namespace: " + this._namespaceName);
                        this._namespace = this.getIvy().getSystemNamespace();
                    }
                } else {
                    this._namespace = this.getIvy().getSystemNamespace();
                    Message.debug(this.getName() + ": no namespace defined: using system");
                }
            } else {
                Message.verbose(this.getName() + ": no namespace defined nor ivy instance: using system namespace");
                this._namespace = Namespace.SYSTEM_NAMESPACE;
            }
        }
        return this._namespace;
    }

    public void setNamespace(String namespaceName) {
        this._namespaceName = namespaceName;
    }

    protected ModuleDescriptor toSystem(ModuleDescriptor md) {
        return NameSpaceHelper.toSystem(md, this.getNamespace());
    }

    protected Artifact fromSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getFromSystemTransformer());
    }

    protected Artifact toSystem(Artifact artifact) {
        return NameSpaceHelper.transform(artifact, this.getNamespace().getToSystemTransformer());
    }

    protected ResolvedModuleRevision toSystem(ResolvedModuleRevision rmr) {
        return NameSpaceHelper.toSystem(rmr, this.getNamespace());
    }

    protected ModuleRevisionId toSystem(ModuleRevisionId resolvedMrid) {
        return this.getNamespace().getToSystemTransformer().transform(resolvedMrid);
    }

    protected DependencyDescriptor fromSystem(DependencyDescriptor dd) {
        return NameSpaceHelper.transform(dd, this.getNamespace().getFromSystemTransformer());
    }

    protected IvyNode getSystemNode(ResolveData data, ModuleRevisionId resolvedMrid) {
        return data.getNode(this.toSystem(resolvedMrid));
    }

    protected ResolvedModuleRevision findModuleInCache(ResolveData data, ModuleRevisionId mrid) {
        return data.getIvy().findModuleInCache(this.toSystem(mrid), data.getCache(), this.doValidate(data));
    }
}

