/*
 * Decompiled with CFR 0.152.
 */
package fr.jayasoft.ivy.namespace;

import fr.jayasoft.ivy.ModuleRevisionId;
import fr.jayasoft.ivy.namespace.NamespaceRule;
import fr.jayasoft.ivy.namespace.NamespaceTransformer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class Namespace {
    public static final Namespace SYSTEM_NAMESPACE = new Namespace();
    private List _rules = new ArrayList();
    private String _name;
    private boolean _chainRules = false;
    private NamespaceTransformer _fromSystemTransformer = new NamespaceTransformer(){

        public ModuleRevisionId transform(ModuleRevisionId mrid) {
            Iterator iter = Namespace.this._rules.iterator();
            while (iter.hasNext()) {
                NamespaceRule rule = (NamespaceRule)iter.next();
                ModuleRevisionId nmrid = rule.getFromSystem().transform(mrid);
                if (Namespace.this._chainRules) {
                    mrid = nmrid;
                    continue;
                }
                if (nmrid.equals(mrid)) continue;
                return nmrid;
            }
            return mrid;
        }

        public boolean isIdentity() {
            return Namespace.this._rules.isEmpty();
        }
    };
    private NamespaceTransformer _toSystemTransformer = new NamespaceTransformer(){

        public ModuleRevisionId transform(ModuleRevisionId mrid) {
            Iterator iter = Namespace.this._rules.iterator();
            while (iter.hasNext()) {
                NamespaceRule rule = (NamespaceRule)iter.next();
                ModuleRevisionId nmrid = rule.getToSystem().transform(mrid);
                if (Namespace.this._chainRules) {
                    mrid = nmrid;
                    continue;
                }
                if (nmrid.equals(mrid)) continue;
                return nmrid;
            }
            return mrid;
        }

        public boolean isIdentity() {
            return Namespace.this._rules.isEmpty();
        }
    };

    public void addRule(NamespaceRule rule) {
        this._rules.add(rule);
    }

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public NamespaceTransformer getFromSystemTransformer() {
        return this._fromSystemTransformer;
    }

    public NamespaceTransformer getToSystemTransformer() {
        return this._toSystemTransformer;
    }

    public boolean isChainrules() {
        return this._chainRules;
    }

    public void setChainrules(boolean chainRules) {
        this._chainRules = chainRules;
    }
}

