# Contributing to the ssh Linux System Role

## Where to start

The first place to go is [Contribute](https://linux-system-roles.github.io/contribute.html).
This has all of the common information that all role developers need:

* Role structure and layout
* Development tools - How to run tests and checks
* Ansible recommended practices
* Basic git and github information
* How to create git commits and submit pull requests

**Bugs and needed implementations** are listed on
[Github Issues](https://github.com/linux-system-roles/ssh/issues).
Issues labeled with
[**help wanted**](https://github.com/linux-system-roles/ssh/issues?q=is%3Aissue+is%3Aopen+label%3A%22help+wanted%22)
are likely to be suitable for new contributors!

**Code** is managed on [Github](https://github.com/linux-system-roles/ssh), using
[Pull Requests](https://help.github.com/en/github/collaborating-with-issues-and-pull-requests/about-pull-requests).

## Developer documentation for ssh system role

### Internal role variables

These variables are used by the role internals and can be used to override
the defaults that correspond to each supported platform.

* `__ssh_packages`:

Minimal list of packages to install on a given platform for openssh clients
to function. Do not override this variable if you need to install additional
packages. Use `ssh_additional_packages` instead.

* `__ssh_drop_in_template`:

The template for a filename used for global drop-in configuration snippets.
The default value is `/etc/ssh/ssh_config.d/{name}.conf`.

* `__ssh_defaults`:

This variable contains a dict with default configuration options available
in the main system-wide configuration file, usually `/etc/ssh/ssh_config`.

* `__ssh_supports_drop_in`:

The boolean flag describing if the system/openssh on the system supports
drop-in directory and this role should use it instead of overriding the
system-wide configuration file.

* `__ssh_supports_validate`:

The boolean flag which controls whether the system/openssh supports test
mode and the generated configuration file can be checked for syntax before
writing to the file-system. Some older versions (for example openssh 5.3p1)
do not support this and need to skip this check.

### Template Generation

The [`ssh_config.j2`](templates/ssh_config.j2) template is programmatically
generated by the scripts in `.dev-tools`. New options should be added to the
`options_body`.

To regenerate the template, from within the `.dev-tools/` directory run:
`./make_option_list >../templates/ssh_config.j2`

### Testing

To run the tests locally in container, you can use the attached Containerfile
(variation for Debian):

```bash
podman build -t system-roles-ssh .dev-tools
podman run -itv ./:/src:Z system-roles-ssh
```
