// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by cmd/cgo -godefs; DO NOT EDIT.
// cgo -godefs types_def.go

package support // import "go.opentelemetry.io/ebpf-profiler/support"

import (
	"go.opentelemetry.io/ebpf-profiler/metrics"
)

const (
	FrameMarkerUnknown  = 0x0
	FrameMarkerErrorBit = 0x80
	FrameMarkerPython   = 0x1
	FrameMarkerNative   = 0x3
	FrameMarkerPHP      = 0x2
	FrameMarkerPHPJIT   = 0x9
	FrameMarkerKernel   = 0x4
	FrameMarkerHotSpot  = 0x5
	FrameMarkerRuby     = 0x6
	FrameMarkerPerl     = 0x7
	FrameMarkerV8       = 0x8
	FrameMarkerDotnet   = 0xa
	FrameMarkerGo       = 0xb
	FrameMarkerAbort    = 0xff
)

const (
	ProgUnwindStop    = 0x0
	ProgUnwindNative  = 0x1
	ProgUnwindHotspot = 0x2
	ProgUnwindPython  = 0x4
	ProgUnwindPHP     = 0x5
	ProgUnwindRuby    = 0x6
	ProgUnwindPerl    = 0x3
	ProgUnwindV8      = 0x7
	ProgUnwindDotnet  = 0x8
	ProgGoLabels      = 0x9
)

const (
	DeltaCommandFlag = 0x8000

	MergeOpcodeNegative = 0x80
)

const (
	EventTypeGenericPID = 0x1
)

const MaxFrameUnwinds = 0x100

const UnwindInfoMaxEntries = 0x4000

const (
	MetricIDBeginCumulative = 0x62
)

const (
	BitWidthPID  = 0x20
	BitWidthPage = 0x40
)

const (
	StackDeltaBucketSmallest = 0x8
	StackDeltaBucketLargest  = 0x17

	StackDeltaPageBits = 0x10
	StackDeltaPageMask = 0xffff
)

const (
	HSTSIDIsStubBit       = 0x3f
	HSTSIDHasFrameBit     = 0x3e
	HSTSIDStackDeltaBit   = 0x38
	HSTSIDStackDeltaMask  = 0x3f
	HSTSIDStackDeltaScale = 0x8
	HSTSIDSegMapBit       = 0x0
	HSTSIDSegMapMask      = 0xffffffffffffff
)

const (
	PerfMaxStackDepth = 0x7f
)

const (
	TraceOriginUnknown  = 0x0
	TraceOriginSampling = 0x1
	TraceOriginOffCPU   = 0x2
	TraceOriginUProbe   = 0x3
)

type ApmSpanID [8]byte
type ApmTraceID [16]byte
type CustomLabel struct {
	Key [16]uint8
	Val [48]uint8
}
type CustomLabelsArray struct {
	Len    uint32
	Labels [10]CustomLabel
}
type Event struct {
	Type uint32
}
type Frame struct {
	File_id        uint64
	Addr_or_line   uint64
	Kind           uint8
	Return_address uint8
	Pad            [6]uint8
}
type OffsetRange struct {
	Lower_offset1 uint64
	Upper_offset1 uint64
	Lower_offset2 uint64
	Upper_offset2 uint64
	Program_index uint16
	Pad_cgo_0     [6]byte
}
type PIDPage struct {
	PrefixLen uint32
	Pid       uint32
	Page      uint64
}
type PIDPageMappingInfo struct {
	File_id                 uint64
	Bias_and_unwind_program uint64
}
type StackDelta struct {
	AddrLow    uint16
	UnwindInfo uint16
}
type StackDeltaPageInfo struct {
	FirstDelta uint32
	NumDeltas  uint16
	MapID      uint16
}
type StackDeltaPageKey struct {
	FileID uint64
	Page   uint64
}
type SystemAnalysis struct {
	Address   uint64
	Pid       uint32
	Code      [128]uint8
	Pad_cgo_0 [4]byte
}
type TSDInfo struct {
	Offset     int16
	Multiplier uint8
	Indirect   uint8
}
type Trace struct {
	Pid                uint32
	Tid                uint32
	Ktime              uint64
	Comm               [16]uint8
	Apm_transaction_id [8]byte
	Apm_trace_id       [16]byte
	Custom_labels      CustomLabelsArray
	Kernel_stack_id    int32
	Stack_len          uint32
	Origin             uint32
	Offtime            uint64
	Frames             [256]Frame
}
type UnwindInfo struct {
	Opcode      uint8
	FpOpcode    uint8
	MergeOpcode uint8
	Param       int32
	FpParam     int32
}

type ApmIntProcInfo struct {
	Offset uint64
}
type DotnetProcInfo struct {
	Version uint32
}
type GoLabelsOffsets struct {
	M_offset               uint32
	Curg                   uint32
	Labels                 uint32
	Hmap_count             uint32
	Hmap_log2_bucket_count uint32
	Hmap_buckets           uint32
	Tls_offset             int32
}
type HotspotProcInfo struct {
	Codecache_start        uint64
	Codecache_end          uint64
	Nmethod_deopt_offset   uint16
	Nmethod_compileid      uint16
	Nmethod_orig_pc_offset uint16
	Codeblob_name          uint8
	Codeblob_codestart     uint8
	Codeblob_codeend       uint8
	Codeblob_framecomplete uint8
	Codeblob_framesize     uint8
	Heapblock_size         uint8
	Method_constmethod     uint8
	Cmethod_size           uint8
	Jvm_version            uint8
	Segment_shift          uint8
	Nmethod_uses_offsets   uint8
	Pad_cgo_0              [7]byte
}
type PHPProcInfo struct {
	Current_execute_data                uint64
	Jit_return_address                  uint64
	Zend_execute_data_function          uint8
	Zend_execute_data_opline            uint8
	Zend_execute_data_prev_execute_data uint8
	Zend_execute_data_this_type_info    uint8
	Zend_function_type                  uint8
	Zend_op_lineno                      uint8
	Pad_cgo_0                           [2]byte
}
type PerlProcInfo struct {
	StateAddr                uint64
	Version                  uint32
	TsdInfo                  TSDInfo
	Interpreter_curcop       uint16
	Interpreter_curstackinfo uint16
	StateInTSD               uint8
	Si_cxstack               uint8
	Si_next                  uint8
	Si_cxix                  uint8
	Si_type                  uint8
	Context_type             uint8
	Context_blk_oldcop       uint8
	Context_blk_sub_retop    uint8
	Context_blk_sub_cv       uint8
	Context_sizeof           uint8
	Sv_flags                 uint8
	Sv_any                   uint8
	Svu_gp                   uint8
	Xcv_flags                uint8
	Xcv_gv                   uint8
	Gp_egv                   uint8
	Pad_cgo_0                [4]byte
}
type PyProcInfo struct {
	AutoTLSKeyAddr                 uint64
	NoneStructAddr                 uint64
	Version                        uint16
	TsdInfo                        TSDInfo
	PyThreadState_frame            uint8
	PyCFrame_current_frame         uint8
	PyFrameObject_f_back           uint8
	PyFrameObject_f_code           uint8
	PyFrameObject_f_lasti          uint8
	PyFrameObject_entry_member     uint8
	PyFrameObject_entry_val        uint8
	PyCodeObject_co_argcount       uint8
	PyCodeObject_co_kwonlyargcount uint8
	PyCodeObject_co_flags          uint8
	PyCodeObject_co_firstlineno    uint8
	PyCodeObject_sizeof            uint8
	Continue_with_next_unwinder    uint8
	Pad_cgo_0                      [5]byte
}
type RubyProcInfo struct {
	Version                      uint32
	Current_ctx_ptr              uint64
	Vm_stack                     uint8
	Vm_stack_size                uint8
	Cfp                          uint8
	Pc                           uint8
	Iseq                         uint8
	Ep                           uint8
	Size_of_control_frame_struct uint8
	Body                         uint8
	Iseq_type                    uint8
	Iseq_encoded                 uint8
	Iseq_size                    uint8
	Size_of_value                uint8
	Running_ec                   uint16
	Pad_cgo_0                    [2]byte
}
type V8ProcInfo struct {
	Version                    uint32
	Type_JSFunction_first      uint16
	Type_JSFunction_last       uint16
	Type_Code                  uint16
	Type_SharedFunctionInfo    uint16
	Off_HeapObject_map         uint8
	Off_Map_instancetype       uint8
	Off_JSFunction_code        uint8
	Off_JSFunction_shared      uint8
	Off_Code_instruction_start uint8
	Off_Code_instruction_size  uint8
	Off_Code_flags             uint8
	Fp_marker                  uint8
	Fp_function                uint8
	Fp_bytecode_offset         uint8
	Codekind_shift             uint8
	Codekind_mask              uint8
	Codekind_baseline          uint8
	Pad_cgo_0                  [3]byte
}

const (
	Sizeof_Frame      = 0x18
	Sizeof_StackDelta = 0x4
	Sizeof_Trace      = 0x1ad0

	sizeof_ApmIntProcInfo = 0x8
	sizeof_DotnetProcInfo = 0x4
	sizeof_PHPProcInfo    = 0x18
	sizeof_RubyProcInfo   = 0x20
)

const (
	UnwindOpcodeCommand   uint8 = 0x0
	UnwindOpcodeBaseCFA   uint8 = 0x1
	UnwindOpcodeBaseSP    uint8 = 0x2
	UnwindOpcodeBaseFP    uint8 = 0x3
	UnwindOpcodeBaseLR    uint8 = 0x4
	UnwindOpcodeBaseReg   uint8 = 0x5
	UnwindOpcodeFlagDeref uint8 = 0x80

	UnwindCommandInvalid      int32 = 0x0
	UnwindCommandStop         int32 = 0x1
	UnwindCommandPLT          int32 = 0x2
	UnwindCommandSignal       int32 = 0x3
	UnwindCommandFramePointer int32 = 0x4

	UnwindDerefMask       int32 = 0x7
	UnwindDerefMultiplier int32 = 0x8
)

const (
	FrameHotspotStub        = 0x0
	FrameHotspotVtable      = 0x1
	FrameHotspotInterpreter = 0x2
	FrameHotspotNative      = 0x3

	V8SmiTag            = 0x0
	V8SmiTagMask        = 0x1
	V8SmiTagShift       = 0x1
	V8SmiValueShift     = 0x20
	V8HeapObjectTag     = 0x1
	V8HeapObjectTagMask = 0x3

	V8FpContextSize = 0x40

	V8FileTypeMarker       = 0x0
	V8FileTypeByteCode     = 0x1
	V8FileTypeNativeSFI    = 0x2
	V8FileTypeNativeCode   = 0x3
	V8FileTypeNativeJSFunc = 0x4
	V8FileTypeMask         = 0x7

	V8LineCookieShift = 0x20
	V8LineCookieMask  = 0xffffffff00000000
	V8LineDeltaMask   = 0xffffffff
)

var MetricsTranslation = []metrics.MetricID{
	0x0:  metrics.IDUnwindCallInterpreter,
	0x1:  metrics.IDUnwindErrZeroPC,
	0x2:  metrics.IDUnwindErrStackLengthExceeded,
	0x3:  metrics.IDUnwindErrBadTLSAddr,
	0x4:  metrics.IDUnwindErrBadTPBaseAddr,
	0x5:  metrics.IDUnwindNativeAttempts,
	0x6:  metrics.IDUnwindNativeFrames,
	0x7:  metrics.IDUnwindNativeStackDeltaStop,
	0x8:  metrics.IDUnwindNativeErrLookupTextSection,
	0x9:  metrics.IDUnwindNativeErrLookupIterations,
	0xa:  metrics.IDUnwindNativeErrLookupRange,
	0xb:  metrics.IDUnwindNativeErrKernelAddress,
	0xc:  metrics.IDUnwindNativeErrWrongTextSection,
	0xe:  metrics.IDUnwindNativeErrPCRead,
	0x15: metrics.IDUnwindPythonAttempts,
	0x16: metrics.IDUnwindPythonFrames,
	0x17: metrics.IDUnwindPythonErrBadPyThreadStateCurrentAddr,
	0x18: metrics.IDUnwindPythonErrZeroThreadState,
	0x19: metrics.IDUnwindPythonErrBadThreadStateFrameAddr,
	0x1c: metrics.IDUnwindPythonZeroFrameCodeObject,
	0x1e: metrics.IDUnwindPythonErrBadCodeObjectArgCountAddr,
	0xd:  metrics.IDUnwindNativeErrStackDeltaInvalid,
	0x28: metrics.IDErrEmptyStack,
	0x29: metrics.IDUnwindHotspotAttempts,
	0x2a: metrics.IDUnwindHotspotFrames,
	0x2b: metrics.IDUnwindHotspotErrNoCodeblob,
	0x2c: metrics.IDUnwindHotspotErrInvalidCodeblob,
	0x2d: metrics.IDUnwindHotspotErrInterpreterFP,
	0x2f: metrics.IDUnwindHotspotErrLrUnwindingMidTrace,
	0x30: metrics.IDHotspotUnsupportedFrameSize,
	0x31: metrics.IDUnwindNativeSmallPC,
	0x32: metrics.IDUnwindNativeErrLookupStackDeltaInnerMap,
	0x33: metrics.IDUnwindNativeErrLookupStackDeltaOuterMap,
	0x34: metrics.IDErrBPFCurrentComm,
	0x22: metrics.IDUnwindPHPAttempts,
	0x23: metrics.IDUnwindPHPFrames,
	0x24: metrics.IDUnwindPHPErrBadCurrentExecuteData,
	0x25: metrics.IDUnwindPHPErrBadZendExecuteData,
	0x26: metrics.IDUnwindPHPErrBadZendFunction,
	0x27: metrics.IDUnwindPHPErrBadZendOpline,
	0x35: metrics.IDUnwindRubyAttempts,
	0x36: metrics.IDUnwindRubyFrames,
	0xf:  metrics.IDUnwindPerlAttempts,
	0x10: metrics.IDUnwindPerlFrames,
	0x11: metrics.IDUnwindPerlTLS,
	0x12: metrics.IDUnwindPerlReadStackInfo,
	0x13: metrics.IDUnwindPerlReadContextStackEntry,
	0x14: metrics.IDUnwindPerlResolveEGV,
	0x2e: metrics.IDUnwindHotspotErrInvalidRA,
	0x37: metrics.IDUnwindV8Attempts,
	0x38: metrics.IDUnwindV8Frames,
	0x39: metrics.IDUnwindV8ErrBadFP,
	0x3a: metrics.IDUnwindV8ErrBadJSFunc,
	0x3b: metrics.IDUnwindV8ErrBadCode,
	0x3d: metrics.IDReportedPIDsErr,
	0x3e: metrics.IDPIDEventsErr,
	0x3c: metrics.IDUnwindNativeLr0,
	0x3f: metrics.IDNumProcNew,
	0x40: metrics.IDNumProcExit,
	0x41: metrics.IDNumUnknownPC,
	0x42: metrics.IDNumGenericPID,
	0x43: metrics.IDUnwindPythonErrBadCFrameFrameAddr,
	0x44: metrics.IDMaxTailCalls,
	0x45: metrics.IDUnwindPythonErrNoProcInfo,
	0x46: metrics.IDUnwindPythonErrBadAutoTlsKeyAddr,
	0x47: metrics.IDUnwindPythonErrReadThreadStateAddr,
	0x48: metrics.IDUnwindPythonErrReadTsdBase,
	0x49: metrics.IDUnwindRubyErrNoProcInfo,
	0x4a: metrics.IDUnwindRubyErrReadStackPtr,
	0x4b: metrics.IDUnwindRubyErrReadStackSize,
	0x4c: metrics.IDUnwindRubyErrReadCfp,
	0x4d: metrics.IDUnwindRubyErrReadEp,
	0x4e: metrics.IDUnwindRubyErrReadIseqBody,
	0x4f: metrics.IDUnwindRubyErrReadIseqEncoded,
	0x50: metrics.IDUnwindRubyErrReadIseqSize,
	0x51: metrics.IDUnwindNativeErrLrUnwindingMidTrace,
	0x52: metrics.IDUnwindNativeErrReadKernelModeRegs,
	0x53: metrics.IDUnwindNativeErrChaseIrqStackLink,
	0x54: metrics.IDUnwindV8ErrNoProcInfo,
	0x55: metrics.IDUnwindNativeErrBadUnwindInfoIndex,
	0x56: metrics.IDUnwindApmIntErrReadTsdBase,
	0x57: metrics.IDUnwindApmIntErrReadCorrBufPtr,
	0x58: metrics.IDUnwindApmIntErrReadCorrBuf,
	0x59: metrics.IDUnwindApmIntReadSuccesses,
	0x5a: metrics.IDUnwindDotnetAttempts,
	0x5b: metrics.IDUnwindDotnetFrames,
	0x5c: metrics.IDUnwindDotnetErrNoProcInfo,
	0x5d: metrics.IDUnwindDotnetErrBadFP,
	0x5e: metrics.IDUnwindDotnetErrCodeHeader,
	0x5f: metrics.IDUnwindDotnetErrCodeTooLarge,
}
