// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package entity

import (
	"go.opentelemetry.io/collector/pdata/internal"
	"go.opentelemetry.io/collector/pdata/pcommon"
)

// This is a reference type, if passed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewEntityRef function to create new instances.
// Important: zero-initialized instance is not valid for use.
type EntityRef internal.EntityRefWrapper

func newEntityRef(orig *internal.EntityRef, state *internal.State) EntityRef {
	return EntityRef(internal.NewEntityRefWrapper(orig, state))
}

// NewEntityRef creates a new empty EntityRef.
//
// This must be used only in testing code. Users should use "AppendEmpty" when part of a Slice,
// OR directly access the member if this is embedded in another struct.
func NewEntityRef() EntityRef {
	return newEntityRef(internal.NewEntityRef(), internal.NewState())
}

// MoveTo moves all properties from the current struct overriding the destination and
// resetting the current instance to its zero value
func (ms EntityRef) MoveTo(dest EntityRef) {
	ms.getState().AssertMutable()
	dest.getState().AssertMutable()
	// If they point to the same data, they are the same, nothing to do.
	if ms.getOrig() == dest.getOrig() {
		return
	}
	internal.DeleteEntityRef(dest.getOrig(), false)
	*dest.getOrig(), *ms.getOrig() = *ms.getOrig(), *dest.getOrig()
}

// SchemaUrl returns the schemaurl associated with this EntityRef.
func (ms EntityRef) SchemaUrl() string {
	return ms.getOrig().SchemaUrl
}

// SetSchemaUrl replaces the schemaurl associated with this EntityRef.
func (ms EntityRef) SetSchemaUrl(v string) {
	ms.getState().AssertMutable()
	ms.getOrig().SchemaUrl = v
}

// Type returns the type associated with this EntityRef.
func (ms EntityRef) Type() string {
	return ms.getOrig().Type
}

// SetType replaces the type associated with this EntityRef.
func (ms EntityRef) SetType(v string) {
	ms.getState().AssertMutable()
	ms.getOrig().Type = v
}

// IdKeys returns the IdKeys associated with this EntityRef.
func (ms EntityRef) IdKeys() pcommon.StringSlice {
	return pcommon.StringSlice(internal.NewStringSliceWrapper(&ms.getOrig().IdKeys, ms.getState()))
}

// DescriptionKeys returns the DescriptionKeys associated with this EntityRef.
func (ms EntityRef) DescriptionKeys() pcommon.StringSlice {
	return pcommon.StringSlice(internal.NewStringSliceWrapper(&ms.getOrig().DescriptionKeys, ms.getState()))
}

// CopyTo copies all properties from the current struct overriding the destination.
func (ms EntityRef) CopyTo(dest EntityRef) {
	dest.getState().AssertMutable()
	internal.CopyEntityRef(dest.getOrig(), ms.getOrig())
}

func (ms EntityRef) getOrig() *internal.EntityRef {
	return internal.GetEntityRefOrig(internal.EntityRefWrapper(ms))
}

func (ms EntityRef) getState() *internal.State {
	return internal.GetEntityRefState(internal.EntityRefWrapper(ms))
}
