// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

// ProfilesData represents the profiles data that can be stored in persistent storage,
// OR can be embedded by other protocols that transfer OTLP profiles data but do not
// implement the OTLP protocol.
type ProfilesData struct {
	ResourceProfiles []*ResourceProfiles
	Dictionary       ProfilesDictionary
}

var (
	protoPoolProfilesData = sync.Pool{
		New: func() any {
			return &ProfilesData{}
		},
	}
)

func NewProfilesData() *ProfilesData {
	if !UseProtoPooling.IsEnabled() {
		return &ProfilesData{}
	}
	return protoPoolProfilesData.Get().(*ProfilesData)
}

func DeleteProfilesData(orig *ProfilesData, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	for i := range orig.ResourceProfiles {
		DeleteResourceProfiles(orig.ResourceProfiles[i], true)
	}
	DeleteProfilesDictionary(&orig.Dictionary, false)

	orig.Reset()
	if nullable {
		protoPoolProfilesData.Put(orig)
	}
}

func CopyProfilesData(dest, src *ProfilesData) *ProfilesData {
	// If copying to same object, just return.
	if src == dest {
		return dest
	}

	if src == nil {
		return nil
	}

	if dest == nil {
		dest = NewProfilesData()
	}
	dest.ResourceProfiles = CopyResourceProfilesPtrSlice(dest.ResourceProfiles, src.ResourceProfiles)

	CopyProfilesDictionary(&dest.Dictionary, &src.Dictionary)

	return dest
}

func CopyProfilesDataSlice(dest, src []ProfilesData) []ProfilesData {
	var newDest []ProfilesData
	if cap(dest) < len(src) {
		newDest = make([]ProfilesData, len(src))
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfilesData(&dest[i], false)
		}
	}
	for i := range src {
		CopyProfilesData(&newDest[i], &src[i])
	}
	return newDest
}

func CopyProfilesDataPtrSlice(dest, src []*ProfilesData) []*ProfilesData {
	var newDest []*ProfilesData
	if cap(dest) < len(src) {
		newDest = make([]*ProfilesData, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfilesData()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteProfilesData(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewProfilesData()
		}
	}
	for i := range src {
		CopyProfilesData(newDest[i], src[i])
	}
	return newDest
}

func (orig *ProfilesData) Reset() {
	*orig = ProfilesData{}
}

// MarshalJSON marshals all properties from the current struct to the destination stream.
func (orig *ProfilesData) MarshalJSON(dest *json.Stream) {
	dest.WriteObjectStart()
	if len(orig.ResourceProfiles) > 0 {
		dest.WriteObjectField("resourceProfiles")
		dest.WriteArrayStart()
		orig.ResourceProfiles[0].MarshalJSON(dest)
		for i := 1; i < len(orig.ResourceProfiles); i++ {
			dest.WriteMore()
			orig.ResourceProfiles[i].MarshalJSON(dest)
		}
		dest.WriteArrayEnd()
	}
	dest.WriteObjectField("dictionary")
	orig.Dictionary.MarshalJSON(dest)
	dest.WriteObjectEnd()
}

// UnmarshalJSON unmarshals all properties from the current struct from the source iterator.
func (orig *ProfilesData) UnmarshalJSON(iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "resourceProfiles", "resource_profiles":
			for iter.ReadArray() {
				orig.ResourceProfiles = append(orig.ResourceProfiles, NewResourceProfiles())
				orig.ResourceProfiles[len(orig.ResourceProfiles)-1].UnmarshalJSON(iter)
			}

		case "dictionary":

			orig.Dictionary.UnmarshalJSON(iter)
		default:
			iter.Skip()
		}
	}
}

func (orig *ProfilesData) SizeProto() int {
	var n int
	var l int
	_ = l
	for i := range orig.ResourceProfiles {
		l = orig.ResourceProfiles[i].SizeProto()
		n += 1 + proto.Sov(uint64(l)) + l
	}
	l = orig.Dictionary.SizeProto()
	n += 1 + proto.Sov(uint64(l)) + l
	return n
}

func (orig *ProfilesData) MarshalProto(buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	for i := len(orig.ResourceProfiles) - 1; i >= 0; i-- {
		l = orig.ResourceProfiles[i].MarshalProto(buf[:pos])
		pos -= l
		pos = proto.EncodeVarint(buf, pos, uint64(l))
		pos--
		buf[pos] = 0xa
	}
	l = orig.Dictionary.MarshalProto(buf[:pos])
	pos -= l
	pos = proto.EncodeVarint(buf, pos, uint64(l))
	pos--
	buf[pos] = 0x12

	return len(buf) - pos
}

func (orig *ProfilesData) UnmarshalProto(buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field ResourceProfiles", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			orig.ResourceProfiles = append(orig.ResourceProfiles, NewResourceProfiles())
			err = orig.ResourceProfiles[len(orig.ResourceProfiles)-1].UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}

		case 2:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field Dictionary", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length

			err = orig.Dictionary.UnmarshalProto(buf[startPos:pos])
			if err != nil {
				return err
			}
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}

func GenTestProfilesData() *ProfilesData {
	orig := NewProfilesData()
	orig.ResourceProfiles = []*ResourceProfiles{{}, GenTestResourceProfiles()}
	orig.Dictionary = *GenTestProfilesDictionary()
	return orig
}

func GenTestProfilesDataPtrSlice() []*ProfilesData {
	orig := make([]*ProfilesData, 5)
	orig[0] = NewProfilesData()
	orig[1] = GenTestProfilesData()
	orig[2] = NewProfilesData()
	orig[3] = GenTestProfilesData()
	orig[4] = NewProfilesData()
	return orig
}

func GenTestProfilesDataSlice() []ProfilesData {
	orig := make([]ProfilesData, 5)
	orig[1] = *GenTestProfilesData()
	orig[3] = *GenTestProfilesData()
	return orig
}
