[comment]: <> (Code generated by mdatagen. DO NOT EDIT.)

# kafka

## Internal Telemetry

The following telemetry is emitted by this component.

### otelcol_kafka_broker_closed

The total number of connections closed. [Development]

Only produced when franz-go is enabled.

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |

### otelcol_kafka_broker_connects

The total number of connections opened. [Development]

Only produced when franz-go is enabled.

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_broker_throttling_duration

The throttling duration in ms imposed by the broker when receiving messages. [Deprecated]

Only produced when franz-go is enabled. Deprecated in favor of kafka_broker_throttling_latency.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Histogram | Int | Deprecated |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |

### otelcol_kafka_broker_throttling_latency

The throttling latency in seconds imposed by the broker when receiving records. [Development]

Only produced when franz-go is enabled.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| s | Histogram | Double | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |

### otelcol_kafka_receiver_bytes

The size in bytes of received records seen by the broker. [Development]

Only produced when franz-go is enabled.

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| By | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_bytes_uncompressed

The uncompressed size in bytes of received records seen by the client. [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| By | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_current_offset

Current message offset [Development]

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| 1 | Gauge | Int | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_latency

The time it took in ms to receive a batch of messages. [Deprecated]

Only produced when franz-go is enabled. Deprecated in favor of kafka_receiver_read_latency.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| ms | Histogram | Int | Deprecated |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_messages

The number of received messages. [Deprecated]

Deprecated in favor of kafka_receiver_records.

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Deprecated |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_offset_lag

Current offset lag [Development]

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| 1 | Gauge | Int | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_partition_close

Number of finished partitions [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

### otelcol_kafka_receiver_partition_start

Number of started partitions [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

### otelcol_kafka_receiver_read_latency

The time it took in seconds to receive a batch of records. [Development]

Only produced when franz-go is enabled.

| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| s | Histogram | Double | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_records

The number of received records. [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| node_id | The Kafka node ID. | Any Int |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
| outcome | The operation outcome. | Str: ``success``, ``failure`` |

### otelcol_kafka_receiver_records_delay

The time in seconds between producing and receiving a batch of records. [Development]

Optional, only reported when enabled via config.
Note that this metric may slow down high-volume consuming.
Only produced when franz-go is enabled.
This metric is reported with an assumption that the exporter and the receiver clocks are synchronized.


| Unit | Metric Type | Value Type | Stability |
| ---- | ----------- | ---------- | --------- |
| s | Histogram | Double | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_unmarshal_failed_log_records

Number of log records failed to be unmarshaled [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_unmarshal_failed_metric_points

Number of metric points failed to be unmarshaled [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_unmarshal_failed_profiles

Number of profiles failed to be unmarshaled [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |

### otelcol_kafka_receiver_unmarshal_failed_spans

Number of spans failed to be unmarshaled [Development]

| Unit | Metric Type | Value Type | Monotonic | Stability |
| ---- | ----------- | ---------- | --------- | --------- |
| 1 | Sum | Int | true | Development |

#### Attributes

| Name | Description | Values |
| ---- | ----------- | ------ |
| topic | The Kafka topic. | Any Str |
| partition | The Kafka topic partition. | Any Int |
